﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class DialogController : MonoBehaviour
{
    public static DialogController instance;

    protected bool isActive = false;
    protected GameObject dialog;
    protected Text text;

    protected string[] dialogTexts;
    protected int dialogCounter;
    protected Action action;

    private void OnEnable()
    {
        instance = this;
        dialog = transform.GetChild(0).gameObject;
        text = dialog.transform.GetChild(0).GetComponentInChildren<Text>();
    }

    public bool IsActive()
    {
        return isActive;
    }

    public void Activate(string[] dialogTexts, Action action = null)
    {
        isActive = true;

        dialog.SetActive(true);

        this.dialogTexts = dialogTexts;
        SetDialogCounter(0);
        this.action = action;
    }

    public void Deactivate()
    {
        isActive = false;
        dialog.SetActive(false);
        action?.Invoke();
    }

    protected void SetDialogCounter(int dc)
    {
        dialogCounter = dc;
        text.text = dialogTexts[dc].Replace("\\n", "\n");
    }

    // Update is called once per frame
    void Update()
    {
        if (!isActive)
        {
            return;
        }

        if (Input.GetButtonDown("Interact"))
        {
            if (dialogCounter + 1 < dialogTexts.Length)
            {
                SetDialogCounter(dialogCounter + 1);
            }
            else
            {
                GameController.instance.StopDialog();
            }
        }
    }
}
